function [ ] = LURNZ_Land_Use_Intensity_Module(pixel_size, output_path, last_year, LUIM_PDFS, LUIM_ASCI, ALL_YEARS )
%
% Module 3 of LURNZ
% the land use intensity module spatially calculates the intensity of land
% use. For dairy farming this is milk solds per hectare. For sheep/beef
% farming this is stock units per hectare. Fertiliser is not considered.
%

% Land Use Intensity Module (LUIM)
% Code by Simon Anastasiadis : 2012-01-13

%% Inform User Module Beginning

msg = sprintf(' - Land Use Intensity Module initialized');
disp(msg)

%% Load data

[GISINTENSITY, c, GISheader, LU_endogenous, LU_exogenous, dairy_coef, dairy_scaling_coef, sheep_scaling_coef ] = LUIM1_load_data(pixel_size, output_path);

%% Run analysis

[dairyMS, SheepSR ] = LUIM2_land_intensity_calculation(GISINTENSITY, c, LU_endogenous, LU_exogenous, dairy_coef, dairy_scaling_coef, sheep_scaling_coef, last_year, ALL_YEARS );

%% Save output

LUIM3_save_results(GISINTENSITY, c, dairyMS, SheepSR, GISheader, output_path, pixel_size, last_year, LUIM_PDFS, LUIM_ASCI, ALL_YEARS );

%% Inform User Module Complete

msg = sprintf(' - Land Use Intensity Module complete');
disp(msg)

end

